program Obiekty3;
uses
	CRT;

type
	TFiguraWsk=^TFigura; {Typ wskaznikowy dla TFigura}
	
	TFigura=object
		private
		      x,y:real;		{ Ogólna pozycja obiektu; interpretacja zależy od spadkobiercy }
		public
			 constructor Inicjalizuj(xp,yp:real);
             procedure Przesun(xn,yn:real);
		     procedure PrzesunDelta(dx,dy:real);
			 procedure WypiszPozycje;
			 function PodajNazwe:string; virtual;
		     function Pole:real; virtual;
		     function Obwod:real; virtual;
		end;	{ TFigura }
		
	TProstokatWsk=^TProstokat; {Typ wskaznikowy dla TProstokat}
	
	TProstokat=object(TFigura)
		   private
			 w,h:real;		{ Szerokość i wysokość}
		   public
			constructor Inicjalizuj(xp,yp,wp,hp:real);
			function PodajNazwe:string; virtual;
			function Pole:real; virtual;
			function Obwod:real; virtual;
		   end;	{ TProstokat }

	TOkragWsk=^TOkrag; {Typ wskaznikowy dla TOkrag}
	
	TOkrag=object(TFigura)
		   private
		         r:real;			{ Promień }
		   public
			constructor Inicjalizuj(xp,yp,rp:real);
			function PodajNazwe:string; virtual;
		    function Pole:real; virtual;
			function Obwod:real; virtual;
		   end;	{ TProstokat }

var
	Prostokat:TProstokat;
	Okrag:TOkrag;
	FiguraWsk1:TFiguraWsk;
	FiguraWsk2:TFiguraWsk;

(*
**	Metody klasy TFigura
*)

(* Konstruktor *)
constructor TFigura.Inicjalizuj(xp,yp:real);
begin
	x:=xp;
	y:=yp;
end;	{ TFigura.Utworz }

(* Wypisuje pozycje *)
procedure TFigura.WypiszPozycje;
begin
	WriteLn('Pozycja ',PodajNazwe,' to: (',x:5:2,',',y:5:2,')'); {:5:2 formatowanie 5 znakow przed przecinkiem i dwa po}
end;	{ TFigura.WypiszPozycje }

(* Przesuwa obiekt na pozycję (x,y)  *)
procedure TFigura.Przesun(xn,yn:real);
begin
	x:=xn;
	y:=yn;
end;	{ TFigura.Przesun }

(* Przesuwa obiekt o dx w poziomie i dy w pionie *)
procedure TFigura.PrzesunDelta(dx,dy:real);
begin
	x:=x+dx;
	y:=y+dy;
end;	{ TGeometr.PrzesunD }

function TFigura.PodajNazwe:string;
begin
	PodajNazwe:='figury';
end;

function TFigura.Pole:real;
begin
	Pole:=0;
end;

function TFigura.Obwod:real;
begin
	Obwod:=0;
end;


(*
**	Metody klasy TProstokat
*)

(* Tworzy prostokąt *)
constructor TProstokat.Inicjalizuj(xp,yp,wp,hp:real);
begin
	inherited Inicjalizuj(xp,yp);
	w:=wp;
	h:=hp;
end;	{ TProstokat.Utworz }

function TProstokat.PodajNazwe:string;
begin
	PodajNazwe:='prostokata';
end;

function TProstokat.Pole:real;
begin
	Pole:=w*h;
end;	{ TProstokat.Pole }

function TProstokat.Obwod:real;
begin
	Obwod:=2*w+2*h;
end;	{ TProstokat.Obwod }


(*
**	Metody klasy TOkrag
*)

(* Tworzy okrąg *)
constructor TOkrag.Inicjalizuj(xp,yp,rp:real);
begin
	inherited Inicjalizuj(xp,yp);
	r:=rp;
end;	{ TOkrag.Utworz }

function TOkrag.PodajNazwe:string;
begin
	PodajNazwe:='okregu';
end;

function TOkrag.Pole:real;
begin
	Pole:=PI*r*r;
end;	{ TOkrag.Pole }

function TOkrag.Obwod:real;
begin
	Obwod:=2*PI*r;
end;	{ TOkrag.Obwod }


begin
	Prostokat.Inicjalizuj(5, 10, 15, 20); { inicjalizacja prostokata wartosciami }
	Prostokat.WypiszPozycje;			  { wywolanie odziedziczonej procedury }
	
	WriteLn();
	
	Okrag.Inicjalizuj(10, 10, 20); { inicjalizacja okregu wartosciami }
	Okrag.WypiszPozycje;
	
	WriteLn();
	WriteLn('Nowa pozycja prostokata:');
	Prostokat.PrzesunDelta(10,10);  { wywolanie odziedziczonej procedury }
	Prostokat.WypiszPozycje;		{ wywolanie odziedziczonej procedury }
	
	WriteLn();
	WriteLn('Nowa pozycja okregu:');
	Okrag.PrzesunDelta(10,10);		{ wywolanie odziedziczonej procedury }
	Okrag.WypiszPozycje;			{ wywolanie odziedziczonej procedury }
	
	WriteLn();
	WriteLn('Pole prostokata: ',Prostokat.Pole:5:2);	{ wywolanie nadpisanej procedury }
    WriteLn('Obwod prostokata: ',Prostokat.Obwod:5:2);	{ wywolanie nadpisanej procedury }
	
	WriteLn();
	WriteLn('Pole okregu: ',Okrag.Pole:5:2);			{ wywolanie nadpisanej procedury }
    WriteLn('Obwod okregu: ',Okrag.Obwod:5:2);			{ wywolanie nadpisanej procedury }
	
	{ przypisanie wskaznikowi typu bazowego obiektu typu podrzednego, tworzonego konstruktorem }
	FiguraWsk1:=New(TProstokatWsk, Inicjalizuj(5, 10, 15, 20));
	
	WriteLn();
	
	{ polimorficzne wywolanie - wskaznik do typu TFigura, a wykonywany jest kod z TProstokat, czyli wskazywanego obiektu }
	WriteLn('Polimorficzne wywolanie pola dla prostokata, pole = ', FiguraWsk1^.Pole:5:2);
	
	{ przypisanie wskaznikowi typu bazowego obiektu typu podrzednego, tworzonego konstruktorem }
	FiguraWsk2:=New(TOkragWsk, Inicjalizuj(10, 10, 20));
	
	WriteLn();
	
	{ polimorficzne wywolanie - wskaznik do typu TFigura, a wykonywany jest kod z TOkrag, czyli wskazywanego obiektu }
	WriteLn('Polimorficzne wywolanie pola dla okregu, pole = ', FiguraWsk2^.Pole:5:2);

	WriteLn();
	WriteLn('Nacisnij klawisz ENTER by zakonczyc...');
	ReadKey;
end.
